unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdExplicitTLSClientServerBase, IdFTP, IdFTPList;

type
  TTypElementu = (tePlik, teKatalog, teLink);
  TElementKatalogu = record
    Nazwa :String;
    Typ :TTypElementu;
    end;
  TForm1 = class(TForm)
    IdFTP1: TIdFTP;
    ListBox1: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Button7: TButton;
    Button8: TButton;
    Edit1: TEdit;
    Button9: TButton;
    Button10: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure IdFTP1Work(ASender: TObject; AWorkMode: TWorkMode;
      AWorkCount: Integer);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
  private
    ZawartoscKatalogu :array of TElementKatalogu;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
try
  IdFTP1.Connect;
  ShowMessage('Poczony z '+IdFTP1.Username+'@'+IdFTP1.Host+'!'+#13+'Katalog: '+IdFTP1.RetrieveCurrentDir);
  Caption:=IdFTP1.Username+'@'+IdFTP1.Host;
except
  on E: Exception do MessageBox(Handle,'Bd przy prbie poczenia','Bd',MB_OK+MB_ICONERROR);
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
IdFTP1.Disconnect;
ShowMessage('Rozczony!');
Caption:='Rozczony';
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
if IdFTP1.Connected then
  begin
  if MessageBox(Handle,'Poczenie z serwerem jest aktywne.'+#13+'Kliknicie OK spowoduje jego zamknicie i zakoczenie dziaania aplikacji.','Uwaga!',MB_OKCANCEL+MB_ICONWARNING)=ID_OK then
    Button2Click(Sender)
    else
    CanClose:=False;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

//IdFTP1.List(ListBox1.Items);
IdFTP1.List(ListBox1.Items,'',True);
end;

procedure TForm1.Button4Click(Sender: TObject);
const pozycja=47;
var
  i,l :Integer;
  s :String;
  katalog,link :Boolean;
  element :TElementKatalogu;
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

ListBox1.Clear;
SetLength(ZawartoscKatalogu,0);
IdFTP1.List('.',True); //biezcy katalog

//Wlasny parser do sunsite
for i:=1 to IdFTP1.ListResult.Count-1 do
  begin
  s:=IdFTP1.ListResult[i];
  katalog:=(s[1]='d');
  link:=(s[1]='l');
  s:=Copy(s,pozycja+1,Length(s)-pozycja); //usuwanie informacji
  s:=Trim(s); //na wszelki wypadek
  if Pos('->',s)>0 then s:=Copy(s,1,Pos('->',s)-2);
  l:=Length(ZawartoscKatalogu);
  SetLength(ZawartoscKatalogu,l+1);
  element.Nazwa:=s;
  element.Typ:=tePlik;
  if katalog then
    begin
    s:='['+s+']';
    element.Typ:=teKatalog;
    end;
  if link then
    begin
    s:=s+'->';
    element.Typ:=teLink;
    end;
  ZawartoscKatalogu[l]:=element;
  ListBox1.Items.Add(s);
  end;

Caption:=IdFTP1.Username+'@'+IdFTP1.Host+'   Katalog: '+IdFTP1.RetrieveCurrentDir;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var pozycja :Integer;
begin
pozycja:=ListBox1.ItemIndex;
//ShowMessage(IntToStr(pozycja)+' - '+ZawartoscKatalogu[pozycja].Nazwa);
case ZawartoscKatalogu[pozycja].Typ of
  teKatalog,teLink:
    begin
    try
      IdFTP1.ChangeDir(ZawartoscKatalogu[pozycja].Nazwa);
      Button4Click(Sender);
    except
      on E :Exception do MessageBox(Handle,PChar('Nie udao si zmieni katalogu ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
    end;
    end;
  tePlik:
    if MessageBox(Handle,PChar('Czy pobra plik '+ZawartoscKatalogu[pozycja].Nazwa+'?'),'Pobieranie',MB_YESNO+MB_ICONQUESTION)=ID_YES then
      Button6Click(Sender);
  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

IdFTP1.ChangeDirUp;
Button4Click(Sender);
end;

procedure TForm1.Button6Click(Sender: TObject);
var pozycja :Integer;
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

pozycja:=ListBox1.ItemIndex;
if (pozycja<0) and not (ZawartoscKatalogu[pozycja].Typ=tePlik) then Exit;
SaveDialog1.FileName:=ZawartoscKatalogu[pozycja].Nazwa;
if SaveDialog1.Execute then
  begin
  try
    IdFTP1.Get(ZawartoscKatalogu[pozycja].Nazwa,SaveDialog1.FileName,True,False);
    ShowMessage('Pobieranie pliku zakoczone');
  except
    on E :Exception do MessageBox(Handle,PChar('Nie udao si pobra pliku ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
  end;
  end;
end;

procedure TForm1.IdFTP1Work(ASender: TObject; AWorkMode: TWorkMode;
  AWorkCount: Integer);
begin
Refresh;
//Application.ProcessMessages;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

if OpenDialog1.Execute then
  begin
  try
    IdFTP1.Put(OpenDialog1.FileName,SaveDialog1.FileName,False);
    ShowMessage('Wysyanie pliku zakoczone');
  except
    on E :Exception do MessageBox(Handle,PChar('Nie udao si wysa pliku ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
  end;
  end;

Button4Click(Sender);
end;

procedure TForm1.Button8Click(Sender: TObject);
var pozycja :Integer;
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

pozycja:=ListBox1.ItemIndex;
if (pozycja<0) and not (ZawartoscKatalogu[pozycja].Typ=tePlik) then Exit;
try
  IdFTP1.Delete(ZawartoscKatalogu[pozycja].Nazwa);
except
  on E :Exception do MessageBox(Handle,PChar('Nie udao si usun pliku z serwera ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
end;

Button4Click(Sender);
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

if Edit1.Text='' then Exit;

try
  IdFTP1.MakeDir(Edit1.Text);
except
  on E :Exception do MessageBox(Handle,PChar('Nie udao si stworzy katalogu ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
end;

Button4Click(Sender);
end;

procedure TForm1.Button10Click(Sender: TObject);
var pozycja :Integer;
begin
if not IdFTP1.Connected then
  begin
  MessageBox(Handle,'Brak poczenia','Bd',MB_OK+MB_ICONERROR);
  Exit;
  end;

pozycja:=ListBox1.ItemIndex;
if (pozycja<0) and not (ZawartoscKatalogu[pozycja].Typ=teKatalog) then Exit;
try
  IdFTP1.RemoveDir(ZawartoscKatalogu[pozycja].Nazwa);
except
  on E :Exception do MessageBox(Handle,PChar('Nie udao si usun katalogu ('+E.Message+')'),'Bd',MB_OK+MB_ICONERROR);
end;

Button4Click(Sender);
end;

end.
